<?php
$wp_customize->add_section(
    'newsletter_area',
    array(
        'title' => __('Newsletter Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'newsletter_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'newsletter_area_disable',
        array(
            'settings'      => 'newsletter_area_disable',
            'section'       => 'newsletter_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'newsletter', 'newsletter_area', $color='#f4f3f3', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'newsletterarea_padding', 'newsletter_area', 'Section Padding');

$wp_customize->add_setting(
    'newsletter_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaTpadding',
    array(
        'settings'      => 'newsletter_areaTpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'newsletter_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaBpadding',
    array(
        'settings'      => 'newsletter_areaBpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'newsimg_display', 'newsletter_area', 'Left Side Image');

$wp_customize->add_setting(
    'newsltrinn_image5',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'newsltrinn_image5',
        array(
            'section' => 'newsletter_area',
            'settings' => 'newsltrinn_image5',
            'description' => __('Recommended Image Size: 570X575px', 'luzuk-premium')
        )
    )
);


addColorPalatOption($wp_customize, 'newsletterarea_imgbrd', 'newsletter_area', 'Image Hover Border Color', '#000');

addColorPalatOption($wp_customize, 'newsletterarea_imghvcolr', 'newsletter_area', 'Image Hover Color', '#fff');

$wp_customize->add_setting(
    'newsletter_page_maintitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'newsletter_page_maintitle_heading',
        array(
            'settings'      => 'newsletter_page_maintitle_heading',
            'section'       => 'newsletter_area',
            'label'         => __( 'Title', 'luzuk-premium' ),
        )
    )
);    
 

$wp_customize->add_setting(
    'newsletter_page_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Architecture<br> Newsletter Signup', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_page_maintitle',
    array(
        'settings'      => 'newsletter_page_maintitle',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Title ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletterarea_title_color', 'newsletter_area', 'Title Color', '#131313');


$wp_customize->add_setting(
    'newsletter_page_tetx',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Subscribe to Our Newsletter to get Important News, Amazing Offers & Inside Scoops. Architecture is both the process and the product of planning, designing', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_page_tetx',
    array(
        'settings'      => 'newsletter_page_tetx',
        'section'       => 'newsletter_area',
        'type'          => 'textarea',
        'label'         => __( 'Text ', 'luzuk-premium' )
    )
);
addColorPalatOption($wp_customize, 'newsletter_page_titleBorderColor', 'newsletter_area', 'Text Color', '#707070');

lzCustomLable($wp_customize, 'newsletter_Form_label', 'newsletter_area', 'Newsletter Form Shortcode');

lzAddElement($wp_customize, 'luzuk_newsletter_shortcode', 'newsletter_area', 'text', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'newsletter_forminputtextColor', 'newsletter_area', 'Form Input text / Placeholder Color', '#a1a1a1');

addColorPalatOption($wp_customize, 'newsletter_forminputbgColor', 'newsletter_area', 'Form Input Background Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_forminputborderColor', 'newsletter_area', 'Form Input Border Color', '#000');

addColorPalatOption($wp_customize, 'newsletter_formlabelColor', 'newsletter_area', 'Form Label Color', '#101a37');

addColorPalatOption($wp_customize, 'newsletter_formbuttontextColor', 'newsletter_area', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_formbuttonbgColor', 'newsletter_area', 'Form Button Background Color', '#000');

addColorPalatOption($wp_customize, 'newsletter_formbuttontexthoverColor', 'newsletter_area', 'Form Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'newsletter_formbuttonbghoverColor', 'newsletter_area', 'Form Button Background Hover Color', '#fff');
