<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">

	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css2?family=Jost:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
	
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'luzuk-premium' ); ?></a>
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header mo-left header-seo">
			<div class="clearfix">
			<?php 
				$Hemiltxt = get_theme_mod('Hemiltxt', 'info@yourmail.com');
				$luzuk_header_fb = get_theme_mod('luzuk_header_fb', '//facebook.com/');
				$luzuk_header_tw = get_theme_mod('luzuk_header_tw', '//twitter.com/');
				$luzuk_header_insta = get_theme_mod('luzuk_header_insta', '//www.instagram.com/');   
            ?>
				<div class="top-bar-head">	
				<?php if($Hemiltxt || $luzuk_header_fb || $luzuk_header_tw || $luzuk_header_insta ){ ?>		
					<div class="header-contact">
						<div class="header-contact-inn"></div>
					 	<div class="container">
							<div class="head-inn">
								<div class="col-md-8 col-sm-8 col-xs-7 padding0">	
								<?php if($Hemiltxt ){ ?>							
									<div class="header-text">
										<a href="mailto:<?php echo $Hemiltxt;?>">
									<i class="fa fa-envelope-o"></i><span class="tooltiptext"><?php echo $Hemiltxt;?></span></a>	
									</div>
									<?php }?>
								</div>
								<div class="col-md-4 col-sm-4 col-xs-5">
									<div class="socialalign padding0">		
										<div class="header-social-links">
											<?php if(!empty($luzuk_header_fb)){ ?>
												<a href="<?php echo $luzuk_header_fb ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
											<?php }?>
											<?php if(!empty($luzuk_header_tw)){ ?>
												<a href="<?php echo $luzuk_header_tw ?>" target="_blank" title="Twitter"><span class="fa-brands fa-x-twitter"></span></a>
											<?php }?>
											<?php if(!empty($luzuk_header_insta)){ ?>
												<a href="<?php echo $luzuk_header_insta ?>" target="_blank" title="instagram"><span class="fa fa-instagram"></span></a>
											<?php }?>
										
										</div>	
										<div class="clearfix"></div>
									</div>
								</div>
								<div class="clearfix"></div>
							</div>
							<div class="clearfix"></div>
						</div> 
						<div class="clearfix"></div>
					</div>
					<?php }?>
					<div class="clearfix"></div>
					<div class="row row-eq-height ">
						<div class="container">
						  <div class="header-b row">
							<div class="header-left lg-md-3 col-md-3 col-sm-4 col-xs-5 logo">
								<div class="inside-full-height">
									<?php 
								
									if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
										$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
									}
									if( get_theme_mod('pages_logoTpadding',true) ) {
										$pages_logoTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTpadding')).';';
									}
									if( get_theme_mod('pages_logoBpadding',true) ) {
										$pages_logoBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBpadding')).';';
									}
									if( get_theme_mod('pages_logoLpadding',true) ) {
										$pages_logoLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLpadding')).';';
									}
									if( get_theme_mod('pages_logoRpadding',true) ) {
										$pages_logoRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRpadding')).';';
									}

								?>
					<!-- website logo -->
								<div class="logo-header mostion">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
									<?php endif; ?>
								</div> 
								<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>   
					<!-- nav toggle button -->
								<div class="resp_header_logo">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
										<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
									<?php endif; ?>
								</div>
							</div>
						</div>

						<div class="header-right lg-md-9 col-md-9 col-sm-8 col-xs-7">
							<div class="row mr-0 ">
								<div class="hd-b-area col-xl-9 col-lg-9 col-md-8 col-sm-3 col-xs-3">		
									<div class="head-menu">
									    <div class="site-navigation ">
					                        <div class="nav-menus">                 
												<a class="js-nav-toggle">
													<span></span>
												</a>
												<div class="nav-wrapper">
													<nav role="navigation">
														<div class="nav-toggle">
															<span class="nav-back"></span>
															<span class="nav-title">Menu</span>
															<span class="nav-close"></span>
														</div>
														<?php
					                                      if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
					                                          wp_nav_menu ( array(
					                                              'menu_class' => 'mainm ht-clearfix',
					                                              'container'=> 'ul',
					                                              'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
					                                              'theme_location' => 'primary',  
					                                          )); 
					                                      } else {
					                                          wp_nav_menu ( array(
					                                              'menu_class' => 'mainm ht-clearfix',
					                                              'container'=> 'ul',
					                                              'theme_location' => 'primary',  
					                                          )); 
					                                      }
						                                ?>
													</nav>
												</div>
											</div>
							                <nav class="navigation">
						                        <div class="overlaybg"></div>
						                        <div class="menu-wrapper">
						                            <div class="menu-content">
						                                <?php
						                                    if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
						                                        wp_nav_menu ( array(
						                                            'menu_class' => 'mainmenu ht-clearfix',
						                                            'container'=> 'ul',
						                                            'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
						                                            'theme_location' => 'primary',  
						                                        )); 
						                                    } else {
						                                        wp_nav_menu ( array(
						                                            'menu_class' => 'mainmenu ht-clearfix',
						                                            'container'=> 'ul',
						                                            'theme_location' => 'primary',  
						                                        )); 
						                                    }
						                                ?>
						                            </div> <!-- /.hours-content-->
												<div class="clearfix"></div>
						                        </div>
						                    </nav>
			   							 <div class="clearfix"></div>
										</div><!--  /.site-navigation -->							
									</div>
								</div>
								<div class="col-xl-3 col-lg-3 col-md-4 col-sm-9 col-xs-9 col-xs-9 hbtn">
									<?php
										$h_btntxt = get_theme_mod('h_btntxt', 'For client support');
				                        $h_button = get_theme_mod('h_button', '+091 4027 905');
				                    ?>
									<?php if(!empty($h_button || $h_btntxt)){ ?>
				                        <div class="Rqst-btn">
				                        	<div class="col-md-2 col-sm-2 col-xs-2 pd-1">
					                        	<i class="fa fa-phone"></i>
					                        </div>
				                        	<div class="col-md-10 col-sm-10 col-xs-10  pd-0">
												<p><?php echo $h_btntxt ?></p>
					                            <a href="tel:<?php echo $h_button;?>"> 
					                               <span class="tooltiptext"> <?php echo $h_button ?></span>
					                            </a>
					                        </div>
				                        </div>
									<?php }?>
								</div>
							</div>
							<div class="clearfix"></div>	
						</div>
						<div class="clearfix"></div>
					</div>
					</div>
						<div class="clearfix"></div>
				  	</div>
					<div class="clearfix"></div>
				</div>
				<div class="clearfix"></div>
			</div>			
			<div class="clearfix"></div>
		</header>
	</div>
