<?php
/**
 * Createing an skill pannel for customizer
 *
 */
// START skill SECTION 
    $wp_customize->add_section(
        'skill_section',
        array(
            'title' => __( 'Our Skill Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    // ENABLE/DISABLE skill SECTION
    $wp_customize->add_setting(
        'skill_section_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'skill_section_disable',
            array(
                'settings'      => 'skill_section_disable',
                'section'       => 'skill_section',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'ourskill', 'skill_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img'); 

lzCustomLable($wp_customize, 'skillsectionleft_padding', 'skill_section', ' Section Padding');

$wp_customize->add_setting(
    'skill_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'skill_toppadding',
    array(
        'settings'      => 'skill_toppadding',
        'section'       => 'skill_section',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'skill_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'skill_bottompadding',
    array(
        'settings'      => 'skill_bottompadding',
        'section'       => 'skill_section',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('skill_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'skill_npp_heading',
        array(
            'settings'      => 'skill_npp_heading',
            'section'       => 'skill_section',
            'label'         => __( 'Number Of Skill Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('skill_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'skill_npp_count',
    array(
        'settings'      => 'skill_npp_count',
        'section'       => 'skill_section',
        'type'          => 'select',
        'label'         => __( 'Number Of Plan To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9)
    )
);

//skill PAGES
for( $i = 1; $i <= 9; $i++ ){
    $wp_customize->add_setting(
        'skill_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'skill_header'.$i,
            array(
                'settings'      => 'skill_header'.$i,
                'section'       => 'skill_section',
                'label'         => __( 'Select A Plan ', 'luzuk-premium' ).$i
            )
        )
    );

lzAddImageElement($wp_customize, 'skill_page_icon'.$i, 'skill_section', $label="Recommended Image Size: 320X350px");
lzAddElement($wp_customize, 'skill_page_title_'.$i, 'skill_section', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Commercial');


lzAddElement($wp_customize, 'skillnew_page_url_'.$i, 'skill_section', $type = 'text', $label="Button Link", $callback ='esc_url', $default='Add link here');

    /*code for button text*/
    $wp_customize->add_setting(
        'skillnew_page_button_title_'.$i,
        array(
            'sanitize_callback'=>'luzuk_sanitize_text',
            'default'=> __('Interior Design', 'luzuk premium')
        )
    );
    $wp_customize->add_control(
        'skillnew_page_button_title_'.$i,
        array(
            'settings' =>'skillnew_page_button_title_'.$i,
            'section' => 'skill_section',
            'type'=> 'text',
            'label'=> __('Button Text', 'luzuk premium')
        )
    );
}

lzCustomLable($wp_customize, 'Color', 'skill_section', ' Section Color');

addColorPalatOption($wp_customize, 'skill_imgovlyColor', 'skill_section', 'Image Overlay Color', '#000');
addColorPalatOption($wp_customize, 'skill_titleColor', 'skill_section', 'Title Color', '#fff');
addColorPalatOption($wp_customize, 'skill_iconColor', 'skill_section', 'Button Text & Icon Color', '#000');
addColorPalatOption($wp_customize, 'skill_iconhvColor', 'skill_section', 'Button Text & Icon Hover Color', '#fff');
addColorPalatOption($wp_customize, 'skill_iconbgvColor', 'skill_section', 'Button Text & Icon Background Color', '#fff');
addColorPalatOption($wp_customize, 'skill_iconbgvhvColor', 'skill_section', 'Button Text & Icon Background Hover Color', '#000');

// End skill section 