<?php
// START CONTACT SECTION 
$wp_customize->add_section(
	'contact_section',
	array(
		'title'         => __( 'Contact Section', 'Luzuk Premium' ), 
		'panel'   => 'luzuk_premium_home_panel',
	)
);
    //ENABLE/DISABLE CONTACT SECTION
$wp_customize->add_setting(
	'contact_area_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'contact_area_disable',
		array(
			'settings'      => 'contact_area_disable',
			'section'       => 'contact_section',
			'label'         => __( 'Disable Section', 'Luzuk Premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk Premium' ),
				'off' => __( 'No', 'Luzuk Premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'contactsec', 'contact_section', $color='#fff', get_template_directory_uri().'/images/Qebg.jpg', 'color');

addColorPalatOption($wp_customize, 'contactsaorlycolor', 'contact_section', 'Overlay Color', '#000');

lzCustomLable($wp_customize, 'counterSectionPadding', 'contact_section', 'Section Padding');

$wp_customize->add_setting(
    'contactsection_toppadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'contactsection_toppadding',
    array(
        'settings'      => 'contactsection_toppadding',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'contactsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'contactsection_bottompadding',
    array(
        'settings'      => 'contactsection_bottompadding',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'appointment_page_maintitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'appointment_page_maintitle_heading',
        array(
            'settings'      => 'appointment_page_maintitle_heading',
            'section'       => 'contact_section',
            'label'         => __( 'Section Title & Section Sub Title', 'luzuk' ),
        )
    )
);    

$wp_customize->add_setting(
    'contact_page_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lets Start New Project', 'luzuk' )
    )
);
$wp_customize->add_control(
    'contact_page_text',
    array(
        'settings'      => 'contact_page_text',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Sub Title', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'contactsarea_text_color', 'contact_section', 'Sub Title Color', '#fff');


$wp_customize->add_setting(
    'contact_page_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Quick Enquiry', 'luzuk' )
    )
);
$wp_customize->add_control(
    'contact_page_maintitle',
    array(
        'settings'      => 'contact_page_maintitle',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Title ', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'contactsarea_title_color', 'contact_section', 'Title Color', '#fff');

addColorPalatOption($wp_customize, 'contactsarea_titlebrd', 'contact_section', 'Title Border Color', '#ccc');


$wp_customize->add_setting(
	'contact_location',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '2189 Holden Street, San Deago,CA,Caliofrnia 92115', 'luzuk' )
	)
);
$wp_customize->add_control(
	'contact_location',
	array(
		'settings'      => 'contact_location',
		'section'       => 'contact_section',
		'type'          => 'textarea',
		'label'         => __( 'Address Text', 'luzuk' )
	)
);

$wp_customize->add_setting(
    'contact_phone',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+1800 123 456 7890', 'luzuk' )
    )
);
$wp_customize->add_control(
    'contact_phone',
    array(
        'settings'      => 'contact_phone',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Phone Number', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'contact_email',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'sapport@architecture.com', 'luzuk' )
    )
);
$wp_customize->add_control(
    'contact_email',
    array(
        'settings'      => 'contact_email',
        'section'       => 'contact_section',
        'type'          => 'textarea',
        'label'         => __( 'Email', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'contact_time',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Monday To Friday 8 AM To 5 PM', 'luzuk' )
    )
);
$wp_customize->add_control(
    'contact_time',
    array(
        'settings'      => 'contact_time',
        'section'       => 'contact_section',
        'type'          => 'textarea',
        'label'         => __( 'Day & Time', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'appointment_dataphoneColor', 'contact_section', 'Icon Color', '#fff');

addColorPalatOption($wp_customize, 'appointment_dataColor', 'contact_section', 'Icon Text Color', '#fff');

addColorPalatOption($wp_customize, 'appointment_emilhv', 'contact_section', 'Email Hover Color', '#ccc');

// button
$wp_customize->add_setting( 'contact_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'contact_button_display', array( 'label' => 'Button Display', 'section' => 'contact_section', 'settings' => 'contact_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
        'contact_button1',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'View On Map', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'contact_button1',
        array(
            'settings'      => 'contact_button1',
            'section'       => 'contact_section',
            'type'          => 'text',
            'label'         => __( 'Add Button Text Here', 'Luzuk' )
        )
    );
$wp_customize->add_setting('contact_link',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('contact_link',
    array(
        'settings'      => 'contact_link',
        'section'       => 'contact_section',
        'type'          => 'url',
        'label'         => __( 'Add Link For Button:', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'contbtntxt', 'contact_section', 'Button Text & Icon Color', '#000');

addColorPalatOption($wp_customize, 'contbtntxthv', 'contact_section', 'Button Text & Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'contbtntxtbg', 'contact_section', 'Button Background Color', '#fff');

addColorPalatOption($wp_customize, 'contbtntxtbghv', 'contact_section', 'Button Background Hover Color', '#000');


// ===========Form Section ==========//


lzCustomLable($wp_customize, 'contactf', 'contact_section', 'Form Section');

lzAddElement($wp_customize, 'luzuk_inquiry_shortcode', 'contact_section', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

//form input text / placeholder color
addColorPalatOption($wp_customize, 'inquiry_forminputtextColor', 'contact_section', 'Form Input Text / Placeholder Color', '#fff');

//form label color
addColorPalatOption($wp_customize, 'inquiry_formlabelColor', 'contact_section', 'Form Label Color', '#fff');

//form text color
addColorPalatOption($wp_customize, 'inquiry_formtextColor', 'contact_section', 'Form Text Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_formtextbrdColor', 'contact_section', 'Form Text Border Color', '#fff');

//form button text color
addColorPalatOption($wp_customize, 'inquiry_formbuttontextColor', 'contact_section', 'Form Button Text Color', '#000');

//form button text color
addColorPalatOption($wp_customize, 'inquiry_formbuttontexthoverColor', 'contact_section', 'Form Button Text Hover Color', '#fff');

//form button background color
addColorPalatOption($wp_customize, 'inquiry_formbuttonbgColor', 'contact_section', 'Form Button Background Color', '#fff');

//form button background color
addColorPalatOption($wp_customize, 'inquiry_formbuttonbghoverColor', 'contact_section', 'Form Button Background Hover color', '#000');
