<?php  
// TESTIMONIALS SECTION START HERE 

$wp_customize->add_section(
    'testimonials_area',
    array(
        'title'         => __( 'Testimonials Section', 'Luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
    //ENABLE/DISABLE TESTIMONIALS SECTION
$wp_customize->add_setting(
    'testimonials_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'testimonials_area_disable',
        array(
            'settings'      => 'testimonials_area_disable',
            'section'       => 'testimonials_area',
            'label'         => __( 'Disable Section', 'Luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk Premium' ),
                'off' => __( 'No', 'Luzuk Premium' )
            )   
        ) 
    )
);
 
backgroundManager($wp_customize, 'testimonials', 'testimonials_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_blogsectionpadding', 'testimonials_area', 'Section Padding');

$wp_customize->add_setting(
    'testimonials_areaTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaTpadding',
    array(
        'settings'      => 'testimonials_areaTpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'Luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'testimonials_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaBpadding',
    array(
        'settings'      => 'testimonials_areaBpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'Luzuk Premium' )
    )
);


$wp_customize->add_setting(
    'luzuk_testimonials_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
       'luzuk_testimonials_title_subtitle_heading',
       array(
           'settings'      => 'luzuk_testimonials_title_subtitle_heading',
           'section'       => 'testimonials_area',
           'label'         => __( 'Heading & Sub Heading', 'Luzuk Premium' ),
       )
   )
);

$wp_customize->add_setting(
    'testimonials_subtitle',
    array(
       'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'What People Says About Us', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_subtitle',
    array(
       'settings'      => 'testimonials_subtitle',
       'section'       => 'testimonials_area',
       'type'          => 'text',
       'label'         => __( 'Sub Heading', 'Luzuk Premium' )
    )
);

addColorPalatOption($wp_customize, 'testiarea_subtitle_color', 'testimonials_area', 'Sub Heading Color', '#979797');


$wp_customize->add_setting(
    'testimonials_title',
    array(
       'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Testimonials', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_title',
    array(
       'settings'      => 'testimonials_title',
       'section'       => 'testimonials_area',
       'type'          => 'text',
       'label'         => __( 'Heading', 'Luzuk Premium' )
    )
);

addColorPalatOption($wp_customize, 'testimonialsarea_sectitle_color', 'testimonials_area', 'Heading Color', '#131313');

addColorPalatOption($wp_customize, 'testiarea_sectitlbrd_color', 'testimonials_area', 'Heading Border Color', '#cccccc');

$TesimonialsSingleChoice[] = 'select';
if(!is_array($TesimonialsSingleChoice)){
    $wp_customize->add_setting('testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Info_Text( 
            $wp_customize,
            'testimonials_area_lbl',
            array(
                'settings'      => 'testimonials_area_lbl',
                'section'       => 'testimonials_area',
                'label'         => __( 'Note:', 'Luzuk Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the Testimonials.</strong> <br/>Please add the Testimonials from "Testimonials menu" and then select Testimonial to show information.', 'Luzuk Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('luzuk_premium_testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_testimonials_area_lbl',
        array(
            'settings'      => 'luzuk_premium_testimonials_area_lbl',
            'section'       => 'testimonials_area',
            'label'         => __( 'Note:', 'Luzuk Premium' ), 
            'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page ', 'Luzuk Premium' ),
        )
    )
);
//TESTIMONIALS PAGES
for( $i = 1; $i < 10; $i++ ){
    $wp_customize->add_setting(
        'luzuk_testimonials_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_testimonials_heading'.$i,
            array(
                'settings'      => 'luzuk_testimonials_heading'.$i,
                'section'       => 'testimonials_area',
                'label'         => __( 'Select Page ', 'Luzuk Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'testimonials_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'testimonials_page'.$i,
        array(
            'settings'      => 'testimonials_page'.$i,
            'section'       => 'testimonials_area',
            'type'=> 'select',
            'label'         => __( 'Select A Page ', 'Luzuk Premium' ),
            'choices' => $TesimonialsSingleChoice,
        )
    );
}

lzCustomLable($wp_customize, 'clientcolor', 'testimonials_area', 'Section Color');


addColorPalatOption($wp_customize, 'testiicncolor', 'testimonials_area', 'Icon Color', '#000');

addColorPalatOption($wp_customize, 'testiicnhvcolor', 'testimonials_area', 'Icon Hover Color', '#ccc');

addColorPalatOption($wp_customize, 'luzuk_testimonials_Namecolor', 'testimonials_area', 'Client Name Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_testimonials_Npsncolor', 'testimonials_area', 'Client Designation Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_testimonialscontent_textcolor', 'testimonials_area', ' Text Color', '#979797');

addColorPalatOption($wp_customize, 'testi_hgbrd1', 'testimonials_area', 'Highlight Border Color', '#000');

addColorPalatOption($wp_customize, 'testi_hgbrd2', 'testimonials_area', 'Highlight Border Hover Color', '#ccc');

addColorPalatOption($wp_customize, 'testi_hbtnbg', 'testimonials_area', 'Slider Button Color', '#ccc');

addColorPalatOption($wp_customize, 'testi_hbtnbghv', 'testimonials_area', 'Slider Active Button Color', '#000');