<?php
$wp_customize->add_section(
    'counter_section',
    array(
        'title' => __( 'Counter Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'counter_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'counter_section_disable',
        array(
            'settings'      => 'counter_section_disable',
            'section'       => 'counter_section',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);
backgroundManager($wp_customize, 'counter', 'counter_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'sec_counterpadding', 'counter_section', 'Section Padding');

$wp_customize->add_setting(
    'counterTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'counterTpadding',
    array(
        'settings'      => 'counterTpadding',
        'section'       => 'counter_section',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'counterBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'counterBpadding',
    array(
        'settings'      => 'counterBpadding',
        'section'       => 'counter_section',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'Luzuk' )
    )
);

$wp_customize->add_setting('counter_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'counter_npp_heading',
        array(
            'settings'      => 'counter_npp_heading',
            'section'       => 'counter_section',
            'label'         => __( 'Number Of Counter Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('counter_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'counter_npp_count',
    array(
        'settings'      => 'counter_npp_count',
        'section'       => 'counter_section',
        'type'          => 'select',
        'label'         => __( 'Number Of Plan To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'counter_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'counter_header'.$i,
            array(
                'settings'      => 'counter_header'.$i,
                'section'       => 'counter_section',
                'label'         => __( 'Select A Plan ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'counter_page_icon'.$i,
        array(
            'default'           => 'fa fa-trophy',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'counter_page_icon'.$i,
            array(
                'settings'      => 'counter_page_icon'.$i,
                'section'       => 'counter_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'counter_page_number_'.$i, 'counter_section', $type = 'text', $label="Number", $callback ='luzuk_sanitize_text', $default='999');

lzAddElement($wp_customize, 'counter_page_title_'.$i, 'counter_section', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Years Of Experience');
    
}


lzCustomLable($wp_customize, 'sec_rightbar_color', 'counter_section', 'Section Color');

addColorPalatOption($wp_customize, 'countericonbxColor', 'counter_section', 'Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'countericonbxhvColor', 'counter_section', 'Box Background Hover Color', '#000');

addColorPalatOption($wp_customize, 'countericonColor', 'counter_section', 'Box Icon Color', '#000');

addColorPalatOption($wp_customize, 'countericonhvColor', 'counter_section', 'Box Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'countertitle', 'counter_section', 'Box Title Color', '#000');

addColorPalatOption($wp_customize, 'countertitlehv', 'counter_section', 'Box Title Hover Color', '#fff');

addColorPalatOption($wp_customize, 'counterttxt', 'counter_section', 'Box Text Color', '#000');

addColorPalatOption($wp_customize, 'counterttxthv', 'counter_section', 'Box Text Hover Color', '#fff');

