<?php 
$wp_customize->add_section(
    'project_area',
    array(
        'title'         => __( 'Project Section', 'Luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);

$wp_customize->add_setting(
    'project_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'project_area_disable',
        array(
            'settings'      => 'project_area_disable',
            'section'       => 'project_area',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'project', 'project_area', $color='#ffffff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_projectectionpadding', 'project_area', 'Section Padding');

$wp_customize->add_setting(
    'project_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'project_areaTpadding',
    array(
        'settings'      => 'project_areaTpadding',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'project_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'project_areaBpadding',
    array(
        'settings'      => 'project_areaBpadding',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'project_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'project_maintitle_subtitle_heading',
        array(
            'settings'      => 'project_maintitle_subtitle_heading',
            'section'       => 'project_area',
            'label'         => __( 'Heading & Sub Heading', 'Luzuk' ),
        )
    )
);


$wp_customize->add_setting(
    'project_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Projects We Have Done', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'project_subtitle',
    array(
        'settings'      => 'project_subtitle',
        'section'       => 'project_area', 
        'type'          => 'textarea',
        'label'         => __( 'Sub Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'projectareasubtitle', 'project_area', 'Sub Heading Color ', '#979797');


$wp_customize->add_setting(
    'project_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Projects', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'project_maintitle',
    array(
        'settings'      => 'project_maintitle',
        'section'       => 'project_area', 
        'type'          => 'text',
        'label'         => __( 'Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'projectarattle', 'project_area', 'Heading Color ', '#000');

addColorPalatOption($wp_customize, 'projectarahedhg', 'project_area', 'Heading Border Color ', '#cccccc');

// Top button
$wp_customize->add_setting( 'proj_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'proj_button_display', array( 'label' => 'Project Top Button Display', 'section' => 'project_area', 'settings' => 'proj_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
        'proj_button1',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'View All Projects', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'proj_button1',
        array(
            'settings'      => 'proj_button1',
            'section'       => 'project_area',
            'type'          => 'text',
            'label'         => __( 'Add Button Text Here', 'Luzuk' )
        )
    );
$wp_customize->add_setting('proj_link',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('proj_link',
    array(
        'settings'      => 'proj_link',
        'section'       => 'project_area',
        'type'          => 'url',
        'label'         => __( 'Add Link For Button:', 'Luzuk' )
    )
);    

addColorPalatOption($wp_customize, 'projtpbtvtxt', 'project_area', 'Top Button Text & Icon Color ', '#fff');

addColorPalatOption($wp_customize, 'projtpbtvtxthv', 'project_area', 'Top Button Text & Icon Hover Color ', '#000');

addColorPalatOption($wp_customize, 'projtpbtvtxtbg', 'project_area', 'Top Button Text & Icon Background Color ', '#000');

addColorPalatOption($wp_customize, 'projtpbtvtxtbghv', 'project_area', 'Top Button Text & Icon Background Hover Color ', '#fff');

$wp_customize->add_setting('project_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'project_area_lbl2',
        array(
            'settings'      => 'project_area_lbl2',
            'section'       => 'project_area',
            'label'         => __( 'Note2:', 'Luzuk' ),  
            'description'   => __( 'Use Shortcode [project] to show all project in a page & images use same height', 'Luzuk' ),
        )
    )
);


$wp_customize->add_setting('project_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'project_npp_heading',
        array(
            'settings'      => 'project_npp_heading',
            'section'       => 'project_area',
            'label'         => __( 'Number Of Project To Show', 'Luzuk' ),
        )
    )
);    
$wp_customize->add_setting('project_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'project_npp_count',
    array(
        'settings'      => 'project_npp_count',
        'section'       => 'project_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Project To Show', 'Luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);


$projectSingleChoice[] = 'Select';
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'project_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'project_heading'.$i,
            array(
                'settings'      => 'project_heading'.$i,
                'section'       => 'project_area',
                'label'         => __( 'Select Page ', 'Luzuk' ).$i,
            )
        )
    );
    if(is_array($projectSingleChoice)){
        $wp_customize->add_setting(
            'project_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'project_page'.$i,
            array(
                'settings'      => 'project_page'.$i,
                'section'       => 'project_area',
                'type'=> 'select',
                'label'         => __( 'Select A Page', 'Luzuk' ),
                'choices' => $projectSingleChoice,
            )
        );

    }else{
        $wp_customize->add_setting('project_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'project_area_lbl'.$i,
                array(
                    'settings'      => 'project_area_lbl'.$i,
                    'section'       => 'project_area',
                    'label'         => __( 'Note:', 'Luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the project Page.</strong> <br/>Please add the project from "project menu" and then select project to show information.', 'Luzuk' ),
                )
            )
        );
    }
 
}

lzCustomLable($wp_customize, 'projectcolor', 'project_area', 'Section Color');

addColorPalatOption($wp_customize, 'projectecimghv', 'project_area', 'Images Overlay Color ', '#000');

addColorPalatOption($wp_customize, 'projectecimgovrlayhv', 'project_area', 'Images Hover Overlay Color ', '#000');

addColorPalatOption($wp_customize, 'projectecttle', 'project_area', 'project Name Color ', '#fff');

addColorPalatOption($wp_customize, 'projectectxt', 'project_area', 'Box Hover Text Color ', '#fff');

$wp_customize->add_setting( 'project_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'project_button_display', array( 'label' => 'Button Display', 'section' => 'project_area', 'settings' => 'project_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button


$wp_customize->add_setting(
    'project_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'View Project', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'project_txt',
    array(
        'settings'      => 'project_txt',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'projectbtn', 'project_area', 'Box Hover Button & Icon Color ', '#fff');

addColorPalatOption($wp_customize, 'projectbtnbg', 'project_area', 'Box Hover Button & Icon Background Color ', '#000');