<?php
$wp_customize->add_section(
    'clientlogo_area',
    array(
        'title' => __('Client Logo Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'clientlogo_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'clientlogo_area_disable',
        array(
            'settings'      => 'clientlogo_area_disable',
            'section'       => 'clientlogo_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'clientlogo', 'clientlogo_area', $color='#f4f3f3', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'clientlogoarea_padding', 'clientlogo_area', 'Section Padding');

$wp_customize->add_setting(
    'clientlogo_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'clientlogo_areaTpadding',
    array(
        'settings'      => 'clientlogo_areaTpadding',
        'section'       => 'clientlogo_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'clientlogo_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'clientlogo_areaBpadding',
    array(
        'settings'      => 'clientlogo_areaBpadding',
        'section'       => 'clientlogo_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);


$wp_customize->add_setting('clientlogo_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'clientlogo_area_lbl',
        array(
            'settings'      => 'clientlogo_area_lbl',
            'section'       => 'clientlogo_area',
            'label'         => __( 'Note1:', 'Luzuk' ),  
            'description'   => __( 'Changes will not reflect unless you select an icon for page', 'Luzuk' ),
        )
    )
);

$wp_customize->add_setting('clientlogo_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'clientlogo_npp_heading',
        array(
            'settings'      => 'clientlogo_npp_heading',
            'section'       => 'clientlogo_area',
            'label'         => __( 'Number Of Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('clientlogo_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'clientlogo_npp_count',
    array(
        'settings'      => 'clientlogo_npp_count',
        'section'       => 'clientlogo_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Plan To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'clientlogo_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'clientlogo_header'.$i,
            array(
                'settings'      => 'clientlogo_header'.$i,
                'section'       => 'clientlogo_area',
                'label'         => __( 'Select A Plan ', 'luzuk-premium' ).$i
            )
        )
    );

    
lzAddImageElement($wp_customize, 'pro_b_page_icon'.$i, 'clientlogo_area', $label="Recommended Image Size:98X79px");
lzAddElement($wp_customize, 'clientlogo_page_url_'.$i, 'clientlogo_area', $type = 'text', $label="Add A Link", $callback ='esc_url', $default='Add link here');
}

lzCustomLable($wp_customize, 'clientlogoarea_color', 'clientlogo_area', 'Section Color');

addColorPalatOption($wp_customize, 'clintlogobrd', 'clientlogo_area', 'Section Logo Hover Border Color', '#000');


 
