<?php
/**
 * Createing an Our Pets pannel for customizer
 */

// START ABOUT SECTION 
$wp_customize->add_section(
    'features_section',
    array(
        'title' => __( 'Feature Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
    // ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'features_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'features_section_disable',
        array(
            'settings'      => 'features_section_disable',
            'section'       => 'features_section',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'features', 'features_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_featuressectionpadding', 'features_section', 'Section Padding');

$wp_customize->add_setting(
    'sec_featuresTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'sec_featuresTpadding',
    array(
        'settings'      => 'sec_featuresTpadding',
        'section'       => 'features_section',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'sec_featuresBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'sec_featuresBpadding',
    array(
        'settings'      => 'sec_featuresBpadding',
        'section'       => 'features_section',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk' )
    )
);

$wp_customize->add_setting('luzuk_featuresslb_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_featuresslb_section_lbl',
        array(
            'settings'      => 'luzuk_featuresslb_section_lbl',
            'section'       => 'features_section',
            'label'         => __( 'Note:', 'Luzuk' ),    
            'description'   => __( 'Changes will not reflect unless you select an Icon', 'Luzuk' ),
        )
    )
);

$wp_customize->add_setting('luzuk_features_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_features_npp_heading',
        array(
            'settings'      => 'luzuk_features_npp_heading',
            'section'       => 'features_section',
            'label'         => __( 'Number Of Features To Show', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('luzuk_features_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'luzuk_features_npp_count',
    array(
        'settings'      => 'luzuk_features_npp_count',
        'section'       => 'features_section',
        'type'          => 'select',
        'label'         => __( 'Number Of Section Box To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//about PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'luzuk_features_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_features_header'.$i,
            array(
                'settings'      => 'luzuk_features_header'.$i,
                'section'       => 'features_section',
                'label'         => __( 'Section Box ', 'luzuk-premium' ).$i
            )
        )
    );

    //lzAddImageElement($wp_customize, 'features_page_icon1'.$i, 'features_section', $label="Recommended Image Size: 290X275px");

$wp_customize->add_setting(
        'features_page_icon1'.$i,
        array(
            'default'           => 'fa fa-shield',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'features_page_icon1'.$i,
            array(
                'settings'      => 'features_page_icon1'.$i,
                'section'       => 'features_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'Luzuk' ),
            )
        )
    );

lzAddElement($wp_customize, 'features_page_title_'.$i, 'features_section', $type = 'text', $label="Section Title", $callback ='luzuk_sanitize_text', $default='Safety Protocols');


lzAddElement($wp_customize, 'fea_page_text'.$i, 'features_section', $type = 'textarea', $label="Description", $callback ='luzuk_sanitize_text', $default='Vivamus est lacus, pretium et vitae, congue euismod quam. Vivamus quis tortor neque.');

$wp_customize->add_setting(
        'featurednew_page_button_title_'.$i,
        array(
            'sanitize_callback'=>'luzuk_sanitize_text',
            'default'=> __('Read More', 'luzuk premium')
        )
    );
    $wp_customize->add_control(
        'featurednew_page_button_title_'.$i,
        array(
            'settings' =>'featurednew_page_button_title_'.$i,
            'section' => 'features_section',
            'type'=> 'text',
            'label'=> __('Button Text', 'luzuk premium')
        )
    );

lzAddElement($wp_customize, 'luzuk_features_page_url_'.$i, 'features_section', $type = 'text', $label="Featured Page Link", $callback ='esc_url', $default='Add link here');

}

lzCustomLable($wp_customize, 'featuresallclr', 'features_section', 'Section Box Color');


lzCustomLable($wp_customize, 'featuresEvenclr', 'features_section', 'Section Even Box Color');

addColorPalatOption($wp_customize, 'membe_pageevnbxbg', 'features_section', 'Box BG Color', '#1A1A1A');

//addColorPalatOption($wp_customize, 'membe_pageevnbxhvbg', 'features_section', 'Box Hover BG Color', '#fff');

addColorPalatOption($wp_customize, 'evemembe_pageicn', 'features_section', 'Icon Color', '#fff');

//addColorPalatOption($wp_customize, 'evemembe_pageicnhv', 'features_section', 'Icon Hover Color', '#1A1A1A');

addColorPalatOption($wp_customize, 'evemembe_pagettl', 'features_section', 'Title Color ', '#fff');

//addColorPalatOption($wp_customize, 'evemembe_pagettlhv', 'features_section', 'Title Hover Color ', '#1A1A1A');

addColorPalatOption($wp_customize, 'evemembe_pagetxt', 'features_section', 'Text Color ', '#fff');

//addColorPalatOption($wp_customize, 'evemembe_pagetxthv', 'features_section', 'Text Hover Color ', '#1A1A1A');

addColorPalatOption($wp_customize, 'evemembe_pagebtntxticn', 'features_section', 'Button Text & Icon Color ', '#fff');

//addColorPalatOption($wp_customize, 'evemembe_pagebtntxticnhv', 'features_section', 'Button Hover Text & Icon Color ', '#1A1A1A');


lzCustomLable($wp_customize, 'featurescolor', 'features_section', 'Section Odd Box Color');

addColorPalatOption($wp_customize, 'membe_pageaddbxbg', 'features_section', 'Box BG Color', '#fff');

//addColorPalatOption($wp_customize, 'membe_pageaddbxbghv', 'features_section', 'Box Hover BG Color', '#1A1A1A');

addColorPalatOption($wp_customize, 'membe_pageicn', 'features_section', 'Icon Color', '#1A1A1A');

//addColorPalatOption($wp_customize, 'membe_pageicnhv', 'features_section', 'Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'membe_pagettl', 'features_section', 'Title Color ', '#1A1A1A');

//addColorPalatOption($wp_customize, 'membe_pagettlhv', 'features_section', 'Title Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'membe_pagetxt', 'features_section', 'Text Color ', '#1A1A1A');

//addColorPalatOption($wp_customize, 'membe_pagetxthv', 'features_section', 'Text Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'membe_pagebtntxticn', 'features_section', 'Button Text & Icon Color ', '#1A1A1A');

//addColorPalatOption($wp_customize, 'membe_pagebtntxticnhv', 'features_section', 'Button Hover Text & Icon Color ', '#ffff');