<?php
/**
 * Createing a bog pannel for customizer
 *
 *
 */
$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
	$cat[$category->term_id] = $category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
	'blog_area',
	array(
		'title' => __( 'Blog Section', 'luzuk-premium' ),
		'panel' => 'luzuk_premium_home_panel',
     	//'priority' => '50',
	)
);
//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
	'blog_area_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'blog_area_disable',
		array(
			'settings'      => 'blog_area_disable',
			'section'       => 'blog_area',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'blog', 'blog_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'blog_area_blogsectionpadding', 'blog_area', 'Section Padding');

$wp_customize->add_setting(
    'blog_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaTpadding',
    array(
        'settings'      => 'blog_areaTpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'blog_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaBpadding',
    array(
        'settings'      => 'blog_areaBpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
	'blog_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text'
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'blog_title_subtitle_heading',
		array(
			'settings'      => 'blog_title_subtitle_heading',
			'section'       => 'blog_area',
			'label'         => __( 'Heading & Sub Heading', 'luzuk-premium' ),
		)
	)
);

$wp_customize->add_setting(
    'blog_title_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Architecture Studio', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_title_subtitle',
    array(
        'settings'      => 'blog_title_subtitle',
        'section'       => 'blog_area',
        'type'          => 'textarea',
        'label'         => __( 'Sub Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'blogarea_secsubtitle_color', 'blog_area', 'Sub Heading Color', '#979797');


$wp_customize->add_setting(
	'blog_title_title',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Latest Blogs', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_title_title',
	array(
		'settings'      => 'blog_title_title',
		'section'       => 'blog_area',
		'type'          => 'text',
		'label'         => __( 'Heading', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'blogarea_sectitle_color', 'blog_area', 'Heading Color', '#131313');
addColorPalatOption($wp_customize, 'blogarea_sectitlhg_color', 'blog_area', 'Heading Border Color', '#ccc');


$wp_customize->add_setting(
	'blog_posttitle',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'POSTED BY : ', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_posttitle',
	array(
		'settings'      => 'blog_posttitle',
		'section'       => 'blog_area',
		'type'          => 'text',
		'label'         => __( 'Blog Post Text', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'blogarea_Tlepost_color', 'blog_area', 'Blog Post Color', '#000');

//BLOG SETTINGS
$wp_customize->add_setting(
	'blog_post_count',
	array(
		'default'           => '1',
		'sanitize_callback' => 'luzuk_sanitize_choices'
	)
);
$wp_customize->add_control(
	new luzuk_Dropdown_Chooser(
		$wp_customize,
		'blog_post_count',
		array(
			'settings'      => 'blog_post_count',
			'section'       => 'blog_area',
			'label'         => __( 'Number Of Posts To Show', 'luzuk-premium' ),
			'choices'       => $luzuk_post_count_choice
		)
	)
);
$wp_customize->add_setting(
	'blog_cat_exclude',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text'
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'blog_cat_exclude',
		array(
			'label' => __('Exclude Category From Blog Posts', 'luzuk-premium'),
			'section' => 'blog_area',
			'settings' => 'blog_cat_exclude',
			'choices' => $luzuk_cat
		)
	)
);
// END BLOG SECTION FOR HOME PAGE
/****************************/


// CREATING A BLOG SECTION IN CUSTOMIZER FOR BLOG PAGES
$wp_customize->add_section(
	'premium_blog_area',
	array(
		'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
		'priority' =>19
	)
);

$wp_customize->add_setting('blog_categories_settings', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('blog_categories_settings', array(
    'settings' => 'blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'luzuk-premium'),
    'section'  => 'lpremium_blog_area',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','luzuk-premium'),
        '1' => __('Full Posts','luzuk-premium'),
    ),
));
// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('blog_categories', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'blog_categories',
		array(
			'label' => __('Exclude Category From Blog Posts', 'luzuk-premium'),
			'section' => 'premium_blog_area',
			'settings' => 'blog_categories',
			'choices' => $cat
		)
	)
);

lzCustomLable($wp_customize, 'blogcolor', 'blog_area', 'Section Color');

addColorPalatOption($wp_customize, 'blogarea_blgbxbg_color', 'blog_area', 'Blog Date Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_datetext_color', 'blog_area', 'Blog Date Text Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_dateicn_color', 'blog_area', 'Blog Date Box Border Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_Tleator_color', 'blog_area', 'Blog Author Color', '#ccc');

addColorPalatOption($wp_customize, 'blogarea_Title_color', 'blog_area', 'Blog Title Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_text_color', 'blog_area', 'Blog Text Color', '#888888');

// button
$wp_customize->add_setting( 'blog_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'blog_button_display', array( 'label' => ' Button Display', 'section' => 'blog_area', 'settings' => 'blog_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
        'blogbutn_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Continue Reading', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'blogbutn_text',
        array(
            'settings'      => 'blogbutn_text',
            'section'       => 'blog_area',
            'type'          => 'text',
            'label'         => __( 'Add Button Text Here', 'Luzuk' )
        )
    );
addColorPalatOption($wp_customize, 'blogarea_sbtn_color', 'blog_area', 'Blog Box Button & Icon Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_sbtnhv', 'blog_area', 'Blog Box Button & Icon Hover Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_sbtnbg', 'blog_area', 'Blog Box Button & Icon Background Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_sbtnbghv', 'blog_area', 'Blog Box Button & Icon Background Hover Color', '#fff');



